/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents an Enrollment Category.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class EnrollmentCategory extends AbstractNamedActiveLookup
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 716299570577191338L;

	/* In-Process Code */
    public static final Code CODE_IN_PROCESS = new Code("P");

    /* Enrolled Code */
    public static final Code CODE_ENROLLED = new Code("E");

    /* Not Enrolled Code */
    public static final Code CODE_NOT_ENROLLED = new Code("N");

    public static class Code extends AbstractCode
    {
        /**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -718996132056594934L;

		private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public EnrollmentCategory()
    {
        super();
    }
}
