/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents an E-mail Type.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class EmailType extends AbstractNamedActiveLookup
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 4157959024804336194L;

	/* Private Code */
    public static final Code CODE_PRIVATE = new Code("1");

    /* Business Code */
    public static final Code CODE_BUSINESS = new Code("2");

    public static class Code extends AbstractCode
    {
        /**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -7320541822892179753L;

		private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public EmailType()
    {
        super();
    }
}
