/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents an E-mail Source of Change.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class EmailSourceOfChange extends AbstractNamedActiveLookup
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -3489964172559040758L;

	/* VAMC Code */
    public static final Code CODE_VAMC = new Code("01");

    /* HEC Code */
    public static final Code CODE_HEC = new Code("02");

    public static class Code extends AbstractCode
    {
        /**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 72260043820197302L;

		private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public EmailSourceOfChange()
    {
        super();
    }
}

