/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents an Enrollment Status.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class EligibilityVerificationSource extends AbstractNamedActiveLookup
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 7688012148279484440L;

	/* VISTA Code */
    public static final Code CODE_VAMC = new Code("VAMC");
    
    public static final Code CODE_MSDS = new Code("MSDS");    

    /* CEV Code */
    public static final Code CODE_CEV = new Code("10");

    /* VBA Code */
    public static final Code CODE_VBA = new Code("12");

    public static class Code extends AbstractCode
    {
        /**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -8095772347759929170L;

		private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public EligibilityVerificationSource()
    {
        super();
    }
}
