package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// Java Classes

// Library Classes

// Framework Classes

/**
 * @author Commons Team
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.class table="ELIGIBILITY_TYPE" mutable="false"
 * @hibernate.cache usage="read-only"
 */
public class EligibilityType extends AbstractNamedActiveLookup {
	
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 3577150090062331304L;

	public static final Code SERVICE_CONNECTED_50_TO_100_PERCENT = new Code("1");

	public static final Code REIMBURSABLE_INSURANCE = new Code("10");

	public static final Code DOM_PATIENT = new Code("11");

	public static final Code CHAMPVA = new Code("12");

	public static final Code COLLATERAL_OF_VETERAN = new Code("13");

	public static final Code EMPLOYEE = new Code("14");

	public static final Code HOUSEBOUND = new Code("15");

	public static final Code MEXICAN_BORDER_WAR = new Code("16");

	public static final Code WORLD_WAR_I = new Code("17");

	public static final Code PRISONER_OF_WAR = new Code("18");

	public static final Code TRICARE_CHAMPUS = new Code("19");

	public static final Code AID_AND_ATTENDANCE = new Code("2");

	public static final Code ELIGIBLE_FOR_MEDICAID = new Code("20");

	public static final Code PURPLE_HEART_RECIPIENT = new Code("22");

	public static final Code SC_LESS_THAN_50_PERCENT = new Code("3");

	public static final Code NSC_VA_PENSION = new Code("4");

	public static final Code NSC = new Code("5");

	public static final Code OTHER_FEDERAL_AGENCY = new Code("6");

	public static final Code ALLIED_VETERAN = new Code("7");

	public static final Code HUMANTARIAN_EMERGENCY = new Code("8");

	public static final Code SHARING_AGREEMENT = new Code("9");
	
   public static final Code[] NON_VETERANS = {
      ALLIED_VETERAN,
      SHARING_AGREEMENT,
      OTHER_FEDERAL_AGENCY,
      COLLATERAL_OF_VETERAN,
      CHAMPVA,
      EMPLOYEE,
      TRICARE_CHAMPUS
   };

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 2206970788450791312L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public EligibilityType() {
		super();
	}
}