/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents an Eligibility Status Pending Verification Reason.
 *
 * @author garepu 
 * @version 4.5.0
 */
public class EligibilityStatusPendVerfiReason extends AbstractNamedActiveLookup
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -7147427207107422189L;

	/* Other Than Honorable Code */
    public static final Code CODE_OTHER_THAN_HONORABLE= new Code("OH");

    /* Signature required Code */
    public static final Code CODE_SIGNATURE_REQUIRED = new Code("SR");

    /* Pending Proof of Qualifying Military Service Code */
    public static final Code CODE_PENDING_PROOF = new Code("PP");
	
    /* Demobililization Code */
    public static final Code CODE_DEMOBILIZATION= new Code("DM");

    /* Active Duty Code */
    public static final Code CODE_ACTIVE_DUTY = new Code("AD");

    /* Other Code */
    public static final Code CODE_OTHER = new Code("OT"); 
    


    public static class Code extends AbstractCode
    {
        /**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -2863330536219785627L;

		private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public EligibilityStatusPendVerfiReason()
    {
        super();
    }
}
