/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents an Eligibility Status.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class EligibilityStatus extends AbstractNamedActiveLookup
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -7147427207107422189L;

	/* Verified Code */
    public static final Code CODE_VERIFIED = new Code("V");

    /* Pending Verification Code */
    public static final Code CODE_PENDING_VERIFICATION = new Code("P");

    /* Pending Reverification Code */
    public static final Code CODE_PENDING_REVERIFICATION = new Code("R");

    public static class Code extends AbstractCode
    {
        /**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -2863330536219785627L;

		private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public EligibilityStatus()
    {
        super();
    }
}
