package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// Java Classes

// Library Classes

// Framework Classes

/**
 * @author Commons Team
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.class table="ELIGIBILITY_TYPE" mutable="false"
 * @hibernate.cache usage="read-only"
 */
public class EligibilityFactor extends AbstractNamedActiveLookup {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 3577150090062441304L;


	public static final Code AGENT_ORANGE_EXPOSURE = new Code("AG");

	public static final Code ENVIRONMENTAL_CONTAMINANTS = new Code("AH");

	public static final Code RADIATION_EXPOSURE = new Code("AI");

	public static final Code CATASTROPHICALLY_DISABLED = new Code("AJ");

	public static final Code HARDSHIP_GRANTED = new Code("AT");

	public static final Code NOSE_THROAT_RADIUM = new Code("AZ");

	public static final Code MILITARY_SEXUAL_TRAUMA = new Code("BA");

	public static final Code SHAD = new Code("BN");

	public static final Code COMBAT_VETERAN = new Code("BP");

	public static final Code MEDICAID = new Code("BQ");

	public static final Code CAMP_LEJEUNE = new Code("CL");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 2206970788450231312L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public EligibilityFactor() {
		super();
		// TODO Auto-generated constructor stub
	}

}
