/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;
import gov.va.med.fw.model.lookup.AbstractCode;

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents an EGT
 * Status Type.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class EGTStatus extends AbstractNamedActiveLookup
{
    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = -2981420260263585287L;

    /** Running */
    public static final Code CODE_RUNNING = new Code("1");

    /** Stopped by User */
    public static final Code CODE_STOPPED_BY_USER = new Code("2");

    /** Finished */
    public static final Code CODE_FINISHED = new Code("3");

    /** Error */
    public static final Code CODE_ERROR = new Code("4");

    public static class Code extends AbstractCode
    {
        /**
         * An instance of serialVersionUID
         */
        
        private static final long serialVersionUID = -4162599586421141314L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public EGTStatus()
    {
        super();
    }
}