/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents an EGT Setting Type.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class EGTSettingType extends AbstractNamedActiveLookup {
	
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 2539089797792814764L;

	/* Mid-Cycle Change Code */
	public static final Code CODE_MID_CYCLE_CHANGE = new Code("3");

	/* Enrollment Decision Code */
	public static final Code CODE_ENROLLMENT_DECISION = new Code("4");

	/* Annual Fiscal Year Code */
	public static final Code CODE_ANNUAL_FISCAL_YEAR = new Code("1");

	/* Stop New Enrollments During Cycle Code */
	public static final Code CODE_STOP_NEW_ENROLLMENTS_DURING_CYCLE = new Code(
			"2");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -5029022131116387681L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public EGTSettingType() {
		super();
	}
}