package gov.va.med.esr.common.model.lookup;

import java.math.BigDecimal;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;

public class DocumentType extends AbstractNamedLookup {


	public static final long serialVersionUID = 7034809798379928345L;
	public static final Code CODE_HANDBOOK_BY_CMS = new Code("Handbook by CMS");
	public static final Code CODE_BENEFITS_PROFILE_BY_CMS =  new Code("Benefits Profile by CMS");
	public static final Code CODE_HANDBOOK_BY_VCG =  new Code("Handbook by VCG");
	public static final Code CODE_BENEFITS_PROFILE_BY_VCG =  new Code("Benefits Profile by VCG");
	public static final Code CODE_HANDBOOK_BY_VET =  new Code("Handbook by Veteran");
	public static final Code CODE_BENEFITS_PROFILE_BY_VET =  new Code("Benefits Profile by Veteran");
	
	public static class Code extends AbstractCode {
		
		private static final long serialVersionUID = 2248585939348485683L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}
	
	public static boolean isBenefitsProfile(DocumentType docType)
	{
		if (docType != null && docType.getCode() != null &&
				(docType.getCode().equals(CODE_BENEFITS_PROFILE_BY_CMS.getCode()) || docType.getCode().equals(CODE_BENEFITS_PROFILE_BY_VCG.getCode()) || docType.getCode().equals(CODE_BENEFITS_PROFILE_BY_VET.getCode())))
			return true;
		return false;
	}
	
	public static boolean isHandBook(DocumentType docType)
	{
		if (docType != null && docType.getCode() != null &&
				(docType.getCode().equals(CODE_HANDBOOK_BY_CMS.getCode()) || docType.getCode().equals(CODE_HANDBOOK_BY_VCG.getCode()) || docType.getCode().equals(CODE_HANDBOOK_BY_VET.getCode())))
			return true;
		return false;
	}
	
	private String fileFormat = null;	
	
	private int versionsKept;

	public String getFileFormat() {
		return fileFormat;
	}

	public void setFileFormat(String fileFormat) {
		this.fileFormat = fileFormat;
	}

	public int getVersionsKept() {
		return versionsKept;
	}

	public void setVersionsKept(int versionsKept) {
		this.versionsKept = versionsKept;
	}
	
	
}
