/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents a Discharge Type.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class DischargeType extends AbstractNamedActiveLookup
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -2801969547670884207L;

	/* Honorable Code */
    public static final Code CODE_HONORABLE = new Code("1");

    /* Dishonorable Code */
    public static final Code CODE_DISHONORABLE = new Code("2");

    /* General Code */
    public static final Code CODE_GENERAL = new Code("3");

    /* Other Than Honorable Code */
    public static final Code CODE_OTHER_THAN_HONORABLE = new Code("4");

    /* Undesirable Code */
    public static final Code CODE_UNDESIRABLE = new Code("5");

    /* Bad Conduct Code */
    public static final Code CODE_BAD_CONDUCT = new Code("6");
    
    /* Dishonorable Code for VA purposes */    
    public static final Code CODE_DISHONORABLE_VA = new Code("8");
    
    /* Honorable Code for VA purposes */
    public static final Code CODE_HONORABLE_VA = new Code("9");
    
    
    public static class Code extends AbstractCode
    {
        /**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -7956223312547328887L;

		private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public DischargeType()
    {
        super();
    }
}