/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents a Disability.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class Disability extends AbstractNamedActiveLookup
{
    // Note: Many other disabilities codes are in the database.

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -2062573403319627989L;
	/* Respiratory Condition - General Code */
    public static final Code CODE_RESPIRATORY_CONDITION_GENERAL = new Code("6899");
    /* Neurogenic Bladder Code */
    public static final Code CODE_NEUROGENIC_BLADDER = new Code("7542");
    // Unspecified neurosis Code
    public static final Code CODE_UNSPECIFIED_NEUROSIS = new Code("9410");
    
    public static class Code extends AbstractCode
    {
        /**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -2455190096668460473L;

		private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public Disability()
    {
        super();
    }
}
