package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

public class Diagnosis extends AbstractNamedActiveLookup {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -2567005424172664703L;
	// Quadriplegia, C1-C4, Complete
    public static final Code CODE_QUADRIPLEGIA_C1_C4_COMPLETE = new Code("344.01");
	// Quadriplegia, C1-C4, Incomplete
    public static final Code CODE_QUADRIPLEGIA_C1_C4_INCOMPLETE = new Code("344.02");
	// Quadriplegia, Unspecified
    public static final Code CODE_QUADRIPLEGIA_UNSPECIFIED = new Code("344.00");
	// Quadriplegia, C5-C7, Incomplete
    public static final Code CODE_QUADRIPLEGIA_C5_C7_INCOMPLETE = new Code("344.04");
	// Other Quadriplegia
    public static final Code CODE_OTHER_QUADRIPLEGIA = new Code("344.09");
	// Paraplegia
    public static final Code CODE_PARAPLEGIA = new Code("344.1");
	// Legal Blindness, as defined in U.S.A.
    public static final Code CODE_LEGAL_BLINDNESS = new Code("369.4");
	// Persistent Vegetative State
    public static final Code CODE_PERSISTENT_VEGETATIVE_STATE = new Code("780.03");
    // ICD10 Legal Blindness, as defined in U.S.A.
    public static final Code ICD10CODE_LEGAL_BLINDNESS = new Code("H54.8");

    public static class Code extends AbstractCode
    {
        /**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -7297506270546862496L;

		private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

	private String codesettype;
   /**
    * Default constructor.
    */
   public Diagnosis() {
      super();
   }
   
   public String getCodesettype() {
       return codesettype;
   }
   
   public void setCodesettype(String codesetType) {
       this.codesettype = codesetType;
   }
}