package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;

/**
 * 
 * @author DNS   ruizc
 *
 */
public class DescriptorType extends AbstractNamedLookup {
	private static final long serialVersionUID = -2134516594630423660L;
	
	public static final Code CODE_QUADRIPLEGIA = new Code("1");	
	public static final Code CODE_PARAPLEGIA = new Code("2");
	public static final Code CODE_PERSISTENT_VEGETATIVE_STATE = new Code("3");
	public static final Code CODE_LEGAL_BLINDNESS = new Code("4");
	public static final Code CODE_AMPUTATION_DISARTICULATION_DETACHMENT = new Code("5");
	public static final Code CODE_DEFICIENCIES_OF_PHYSICAL_OR_MENTAL_FUNCTION = new Code("6");
	public static final Code CODE_DEAFNESS = new Code("7");	

	public static class Code extends AbstractCode {

		private static final long serialVersionUID = 8902511941032393894L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}	
	
	public DescriptorType() {
		super();
	}

}
