/**
 * 
 */
package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;

/**
 * @author DNS   CHINNR
 */
public class DeliveryPreferenceType extends AbstractNamedLookup {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -1678221964418870657L;
	
	/* Mail Code */
	public static final Code CODE_MAIL = new Code("1");

	/* ONLINE Code */
	public static final Code CODE_ONLINE = new Code("2");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -2863164484619472436L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public DeliveryPreferenceType() {
		super();	
	}

}
