package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;

public class DeliveryPreferenceSourceOfChange extends AbstractNamedLookup{

	/**
	 * 
	 */
	private static final long serialVersionUID = -4460574757022024598L;
	/* Veteran Self Service Code */
    public static final Code CODE_VSS = new Code("VSS");

    /* Health Eligibility Center Code */
    public static final Code CODE_HEC = new Code("HEC");

    public static class Code extends AbstractCode
    {
        /**
		 * 
		 */
		private static final long serialVersionUID = 4609733486616040798L;

		/**
		 * An instance of serialVersionUID
		 */

		private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public DeliveryPreferenceSourceOfChange()
    {
        super();
    }

}
