/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents a Purple Heart Decoration
 * Status.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class DecorationStatus extends AbstractNamedActiveLookup
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 3353923354823809309L;

	/* Confirmed Code */
    public static final Code CODE_CONFIRMED = new Code("3");

    /* Initial Letter Sent Code */
    public static final Code CODE_INITIAL_LETTER_SENT = new Code("4");

    /* Second Letter Sent Code */
    public static final Code CODE_REJECTED = new Code("5");

    /* Pending Code */
    public static final Code CODE_PENDING = new Code("1");

    /* In Progress Code */
    public static final Code CODE_IN_PROGRESS = new Code("2");

    public static class Code extends AbstractCode
    {
        /**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -482229931942046299L;

		private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public DecorationStatus()
    {
        super();
    }
}
