/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

public class DeathDataSource
    extends AbstractNamedActiveLookup {

    /** VBA */
    public static final Code CODE_VBA = new Code("4");

    //CCR 13856
    public static final Code CODE_NCA = new Code("7");

    // CCR 11321 Date of Death
    public static final Code CODE_DEATH_CERT_ON_FILE = new Code("3");

    public static class Code extends AbstractCode
    {
        /**
         * An instance of serialVersionUID
         */
        private static final long serialVersionUID = -4601097749794877950L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -241740508298608213L;

	/**
     * Default constructor.
     */
    public DeathDataSource() {
        super();
    }
}