/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Feb 24, 2006
 *
 */
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// EDB Classes

/**
 * @author Yi He
 * @version 1.0
 */
public class DayOfMonth extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 8175061170616446582L;	                                            

	public static final Code CODE_FIRST = new Code("1","1");

	public static final Code CODE_LAST = new Code("2","L");

	public static final Code CODE_15TH = new Code("3","15");

	public DayOfMonth() {
		super();
	}
	
    public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -9209133451284526547L;	                                            
		
		private Code(String code, String alias) {
			super(code,alias);
		}
      
		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}	
}