package gov.va.med.esr.common.model.lookup;

// Java Classes
import java.math.BigDecimal;

// Library Classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework Classes
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

/**
 * The County class.
 */
public class County extends AbstractNamedActiveLookup
{
    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = -2782087391099753618L;

    private BigDecimal stateId;

    private State state;

    private String countyNumber;

    /**
     * Default constructor.
     */
    public County()
    {
        super();
    }

    public BigDecimal getStateId()
    {
        return stateId;
    }

    public void setStateId(BigDecimal stateId)
    {
        this.stateId = stateId;
    }

    /**
     * Returns the state for this county.
     *
     * @return The state for this county.
     */
    public State getState()
    {
        return this.state;
    }

    /**
     * Sets the state for this county.
     *
     * @param state The state for this county.
     */
    public void setState(State state)
    {
        this.state = state;
    }

    /**
     * Returns the unique number code for this county.
     *
     * @return The unique number code for this county.
     */
    public String getCountyNumber()
    {
        return this.countyNumber;
    }

    /**
     * Sets the unique number code for this county.
     *
     * @param countyNumber The unique number code for this county.
     */
    public void setCountyNumber(String countyNumber)
    {
        this.countyNumber = countyNumber;
    }

    public void setName(String name)
    {
        if (name != null)
        {
            name = name.toUpperCase();
        }
        super.setName(name);
    }

    public void setDescription(String description)
    {
        if (description != null)
        {
            description = description.toUpperCase();
        }
        super.setDescription(description);
    }

    /**
     * Gets the description by returning the name.
     */
    public String getDescription()
    {
        return getName();
	}

    /*
      * (non-Javadoc)
      *
      * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
      */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder.append("state", this.state).append(
            "countyNumber", this.countyNumber));
    }

    /**
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable
    {
        super.finalize();

        this.state = null;
        this.countyNumber = null;
    }
}