/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import java.util.Date;
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;
import gov.va.med.fw.util.DateUtils;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM).
 * This class represents a Conflict Location.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class ConflictLocation extends AbstractNamedActiveLookup {
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -182355182582355048L;

	/* World War I Code */
    public static final Code CODE_WORLD_WAR_I = new Code("1");

    /* World War II - Europe Code */
    public static final Code CODE_WORLD_WAR_II_EUROPE = new Code("2");

    /* World War II - Pacific Code */
    public static final Code CODE_WORLD_WAR_II_PACIFIC = new Code("3");

    /* Korea Code */
    public static final Code CODE_KOREA = new Code("4");

    /* Vietnam Code */
    public static final Code CODE_VIETNAM = new Code("5");

    /* Other Code */
    public static final Code CODE_OTHER = new Code("6");

    /* Persian Gulf War Code */
    public static final Code CODE_PERSIAN_GULF_WAR = new Code("7");

    /* Yugoslavia Conflict Code */
    public static final Code CODE_YUGOSLAVIA_CONFLICT = new Code("8");

    /* Lebanon Code */
    public static final Code CODE_LEBANON = new Code("9");

    /* Grenada Code */
    public static final Code CODE_GRENADA = new Code("10");

    /* Panama Code */
    public static final Code CODE_PANAMA = new Code("11");
    
    /* Somalia Code */
    public static final Code CODE_SOMALIA = new Code("12");

    /* OEF */
    public static final Code CODE_OEF = new Code("13");
    
    /* OIF */
    public static final Code CODE_OIF = new Code("14");
    
    /* Unknown OEF/OIF */
    public static final Code CODE_UNKNOWN_OEF_OIF = new Code("15");
    
    /* Conflict Unspecified */
    public static final Code CODE_CONFLICT_UNSPECIFIED = new Code("16");
    

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 8034768661193412476L;
		private Code(String code) {	super(code); }
		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}
	
	private Date startDate = null;

	private Date endDate = null;

    /**
     * Default constructor.
     */
    public ConflictLocation()
    {
        super();
    }
    

    public Date getStartDate() {
		return this.startDate;
	}
    
	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return this.endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
    
    public String getNameAndDateRange () {
        StringBuffer nameDate = new StringBuffer(this.getName());
        
        String start = (this.getStartDate() != null) ? DateUtils.format(this.getStartDate(),DateUtils.MMDDYYYY) : null;
        String end = (this.getStartDate() != null) ? DateUtils.format(this.getEndDate(),DateUtils.MMDDYYYY) : null;
        
        if(start != null) {
            if(end == null) end = "...";
            nameDate.append(" - (" + start + " to " + end + ")");
        }
        return nameDate.toString();
    }
}