/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on May 23, 2006
 *
 */
package gov.va.med.esr.common.model.lookup;


// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;
import gov.va.med.fw.util.StringUtils;

// EDB Classes

/**
 * @author Yi He
 * @version 1.0
 */
public class ConfidentialAddressCategoryType extends AbstractNamedActiveLookup {

	public ConfidentialAddressCategoryType() {
		super();
	}

	private static final long serialVersionUID = -2276551215446658036L;

	public static final Code CODE_ELIGIBILITY_ENROLLMENT = new Code("1");

	public static final Code CODE_APPOINTMENT_SCHEDULING = new Code("2");

	public static final Code CODE_COPAYMENTS_VETERANBILLING = new Code("3");

	public static final Code CODE_MEDICAL_RECORDS = new Code("4");

	public static final Code CODE_ALL_OTHERS = new Code("5");
	
	/**
     * Returns the station number plus the description.
     * @return the site number and name.
     */
    public String getCategoryTypeCodeAndName()
    {
        StringBuffer buffer = new StringBuffer();
        if (StringUtils.isNotEmpty(getCode()))
        {
            buffer.append(getCode());
        }
        if (StringUtils.isNotEmpty(getDescription()))
        {
            if (buffer.length() > 0)
            {
                buffer.append(" - ");
            }
            buffer.append(getDescription());
        }
        return buffer.toString();
    }

	public static class Code extends AbstractCode {

        private static final long serialVersionUID = -7314393128818969534L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}
	
}

