package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// Java Classes

// Library Classes

// Framework Classes

/**
 * @author Commons Team
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.class table="CONDITION" mutable="false"
 * @hibernate.cache usage="read-only"
 */
public class Condition extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -2276551215446658036L;

	/* FIM Code */
	public static final Code CODE_FIM = new Code("4");

	/* GAF Code */
	public static final Code CODE_GAF = new Code("5");

	/* KATZ Code */
	public static final Code CODE_KATZ = new Code("1");

	/* FOLS Code */
	public static final Code CODE_FOLS = new Code("2");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 1601552589134871019L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public Condition() {
		super();
	}
}