/**
 * 
 */
package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;

/**
 * @author DNS   KATIKM
 * This represents Combat Service Source
 * Version 3.1
 */
public class CombatServiceSource extends AbstractNamedLookup {
	
	private static final long serialVersionUID = 2029851929200220664L;

    //FHIE	Federal Health Information Exchange Program
	public static final Code CODE_FEDERAL_HEALTH_INFORMATION_EXCHANGE_PROGRAM = new Code("FHIE");

	//VIS	Veteran Information System
	public static final Code CODE_VETERAN_INFORMATION_SYSTEM = new Code("VIS");

	//EM	Environmental Medicine
	public static final Code CODE_ENVIRONMENTAL_MEDICINE = new Code("EM");
	
	//VADIR 
	public static final Code CODE_VADIR = new Code("VADR");
	
	//VBA
	public static final Code CODE_WEBHINQ = new Code("WEBH");	
	
	//Inner class
	public static class Code extends AbstractCode {

		private static final long serialVersionUID = 5710067180038331227L;

        private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public CombatServiceSource() {
		super();
	}
}
