/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.model.lookup;

import java.util.Date;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;

/**
 * @author DNS   KATIKM
 * This represents Combat Service Location
 * Version 3.1
 */
public class CombatServiceLocation extends AbstractNamedLookup {

	private static final long serialVersionUID = -4415580861952529140L;
	
    /*define the codes as required */
	
	public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = 3021238010553550137L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }
    //area is mapped to name
    private Date startDate = null;
    private Date endDate = null;
    private String includedLocations = null;
    
    public CombatServiceLocation() {
    	super();
    }
    
    public String getArea() {
    	return getName();
    }
	public Date getEndDate() {
		return this.endDate;
	}
	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
	public String getIncludedLocations() {
		return this.includedLocations;
	}
	public void setIncludedLocations(String includedLocations) {
		this.includedLocations = includedLocations;
	}
	public Date getStartDate() {
		return this.startDate;
	}
	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}    
}
