/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;

/**
 * @author DNS   KATIKM
 * This represents Combat Pay Type
 * Version 3.0
 */
public class CombatPayType extends AbstractNamedLookup {

	private static final long serialVersionUID = 5357693736104776654L;

	//01	CZTE	Combat Zone Tax Exclusion
	public static final Code CODE_COMBAT_ZONE_TAX_EXCLUSION = new Code("01");
	
	//02	HF/ID	Hostile Fire/Imminent Danger
	public static final Code CODE_HOSTILE_FIRE_IMMINENT_DANGER = new Code("02");
	
	//Inner class
	public static class Code extends AbstractCode {

		private static final long serialVersionUID = 8124095915999845747L;

        private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public CombatPayType() {
		super();
	}
}
