/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

//Framework Classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

/**
 * Lookup class for Com Mailing Status Type.
 * 
 * Project: Common
 * @author Ghazenfer Mansoor 
 * @version 1.0
 */
public class ComMailingStatusType extends AbstractNamedActiveLookup {
    
    public static final Code  SEND_TO_AAC = new Code("0");
    public static final Code  SENT_TO_AAC = new Code("1");
    public static final Code  MAILED_BY_HEC = new Code("2");
    public static final Code  REJECT_AT_HEC = new Code("3");
    public static final Code  REJECT_BY_AAC = new Code("4");
    public static final Code  ERROR_BY_AAC = new Code("5");
    public static final Code  RETURN_BY_POST_OFFICE = new Code("6");
    public static final Code  MAILED_BY_AAC = new Code("7");
    public static final Code  SENT_TO_HEC_PRINTER = new Code("8");
    public static final Code  ADDRESS_CHANGED_AND_MAILED_BY_AAC = new Code("9");
    public static final Code  CANCEL_BY_HEC = new Code("10");
    public static final Code  SEND_TO_CMS = new Code("11");
    public static final Code  SENT_TO_CMS = new Code("12");
    public static final Code  REJECT_BY_CMS = new Code("13");
    public static final Code  ERROR_BY_CMS = new Code("14");    
    public static final Code  MAILED_BY_CMS = new Code("15");    
    
    
    public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = -4538970715458725830L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -7292076344680536715L;

	/**
     * Default constructor.
     */
    public ComMailingStatusType() {
        super();
    }
}