/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

//Framework Classes
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;
import gov.va.med.fw.model.lookup.AbstractCode;

/**
 * Lookup class for Com Letter Type.
 * <p/>
 * Project: Common
 *
 * @author Ghazenfer Mansoor
 * @version 1.0
 */
public class ComLetterType extends AbstractNamedActiveLookup
{
    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = -139184352180834425L;

    /**
     * Enrollment Type
     */
    public static final Code CODE_ENROLLMENT = new Code("3");

    /**
     * MT Type
     */
    public static final Code CODE_MT = new Code("4");

    /**
     * SSN Type
     */
    public static final Code CODE_SSN = new Code("5");

    /**
     * General Type
     */
    public static final Code CODE_GENERAL = new Code("1");

    /**
     * IVM Type
     */
    public static final Code CODE_IVM = new Code("2");

    /**
     * Handbook Type
     */
    public static final Code CODE_HANDBOOK = new Code("6");
   
    
    /**
     */
    public static class Code extends AbstractCode
    {
        /**
         * An instance of serialVersionUID
         */
        private static final long serialVersionUID = -3391288511400002591L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public ComLetterType()
    {
        super();
    }
}