package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework classes
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents a city.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class City extends AbstractNamedActiveLookup
{
    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = 3428387845769991156L;

    private boolean approvedMailingName;

    private String abbreviatedName;

    /**
     * Default constructor.
     */
    public City()
    {
        super();
    }

    public boolean isApprovedMailingName()
    {
        return approvedMailingName;
    }

    public void setApprovedMailingName(boolean approvedMailingName)
    {
        this.approvedMailingName = approvedMailingName;
    }

    public String getAbbreviatedName()
    {
        return abbreviatedName;
    }

    public void setAbbreviatedName(String abbreviatedName)
    {
        this.abbreviatedName = abbreviatedName;
    }

    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder.append("approvedMailingName",
            this.approvedMailingName).append("abbreviatedName",
            this.abbreviatedName));
    }

    public void setName(String name)
    {
        if (name != null)
        {
            name = name.toUpperCase();
        }
        super.setName(name);
    }

    public void setDescription(String description)
    {
        if (description != null)
        {
            description = description.toUpperCase();
        }
        super.setDescription(description);
    }
}