/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

public class Capability extends AbstractNamedActiveLookup implements Comparable{

    private static final long serialVersionUID = -1382776849337683408L;

    //updated set of capabilities ordered by use case
    //previous codes are retained for compatiability

    //UC Generate Standard Reports
    public static final Code SCHEDULE_RUN_ENROLLMENT_REPORTS = new Code("1001"); //Schedule/Run Enrollment Reports
    public static final Code SCHEDULE_RUN_CANCEL_DECLINE_REPORTS = new Code("1002"); //Schedule/Run Cancel/Decline Reports
    public static final Code SCHEDULE_RUN_FIN_ASSESMENT_REPORTS = new Code("1003"); //Schedule/Run Financial Assessment Reports
    public static final Code SCHEDULE_RUN_ADDRESS_REPORTS = new Code("1004"); //Schedule/Run Address Reports
    public static final Code SCHEDULE_RUN_SSN_REPORTS = new Code("1005"); //Schedule/Run SSN Reports
    public static final Code SCHEDULE_RUN_MST_REPORTS = new Code("1006"); //Schedule/Run MST Reports
    public static final Code SCHEDULE_RUN_WORKLOAD_REPORTS = new Code("1007"); //Schedule/Run Workload Reports
    public static final Code SCHEDULE_RUN_CORRESPONDENCE_REPORTS = new Code("1008"); //Schedule/Run Correspondence Reports
    public static final Code SCHEDULE_RUN_INSURANCE_REPORTS = new Code("1009"); //Schedule/Run Insurance Reports
    public static final Code SCHEDULE_RUN_MESSAGING_REPORTS = new Code("1010"); //Schedule/Run Messaging Reports
    public static final Code SCHEDULE_RUN_QUALITY_MGMT_REPORTS = new Code("1011"); //Schedule/Run Quality Management Reports
    public static final Code SCHEDULE_RUN_DUP_MERGE_REPORTS = new Code("1012"); //Schedule/Run Duplicate Merge Reports
    public static final Code SCHEDULE_RUN_PURPLE_HEART_REPORTS = new Code("1013"); //Schedule/Run Purple Heart Reports
    public static final Code SCHEDULE_RUN_OPP_REPORTS = new Code("1014"); //Schedule/Run OPP Reports
    public static final Code SCHEDULE_RUN_BULK_REGISTRY_LOAD_REPORTS = new Code("1015"); //Schedule/Run Bulk Registry Load Reports
    public static final Code SCHEDULE_RUN_VOA_REPORTS = new Code("4219"); //Schedule/Run VOA Progressing Status/Demographic Reports
    public static final Code SCHEDULE_RUN_ACA_REPORTS = new Code("4221"); //Schedule/Run ACA Progressing Status/Demographic Reports
    public static final String SCHEDULE_RUN_REPORTS ="1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1011,1012,1013,1014,1015,4212,4219,4221";
    public static final String VIEW_REPORTS = SCHEDULE_RUN_REPORTS + "," +
    	"1101,1102,1103,1104,1105,1106,1107,1108,1109,1110,1111,1112,1113,1114,1115,4213,4220,4222";

    public static final String VIEW_ONLY_REPORTS ="1101,1102,1103,1104,1105,1106,1107,1108,1109,1110,1111,1112,1113,1114,1115,4213,4220,4222";

    public static final Code VIEW_ENROLLMENT_REPORTS = new Code("1101"); //View Enrollment Reports
    public static final Code VIEW_CANCEL_DECLINE_REPORTS = new Code("1102"); //View Cancel/Decline Reports
    public static final Code VIEW_FIN_ASSESMENT_REPORTS = new Code("1103"); //View Financial Assessment Reports
    public static final Code VIEW_ADDRESS_REPORTS = new Code("1104"); //View Address Reports
    public static final Code VIEW_SSN_REPORTS = new Code("1105"); //View SSN Reports
    public static final Code VIEW_MST_REPORTS = new Code("1106"); //View MST Reports
    public static final Code VIEW_WORKLOAD_REPORTS = new Code("1107"); //View Workload Reports
    public static final Code VIEW_CORRESPONDENCE_REPORTS = new Code("1108"); //View Correspondence Reports
    public static final Code VIEW_INSURANCE_REPORTS = new Code("1109"); //View Insurance Reports
    public static final Code VIEW_MESSAGING_REPORTS = new Code("1110"); //View Messaging Reports
    public static final Code VIEW_QUALITY_MGMT_REPORTS = new Code("1111"); //View Quality Management Reports
    public static final Code VIEW_DUP_MERGE_REPORTS = new Code("1112"); //View Duplicate Merge Reports
    public static final Code VIEW_PURPLE_HEART_REPORTS = new Code("1113"); //View Purple Heart Reports
    public static final Code VIEW_OPP_REPORTS = new Code("1114"); //View OPP Reports
    public static final Code VIEW_BULK_REGISTRY_LOAD_REPORTS = new Code("1115"); //View Bulk Registry Load Reports
    public static final Code VIEW_VOA_REPORTS = new Code("4220"); //View VOA Reports
    public static final Code VIEW_ACA_REPORTS = new Code("4222"); //View ACA Reports

    //Person Merge
    public static final Code VIEW_VETERAN_MERGED_PAIRS = new Code("1201"); //View Veteran Merged Pairs
    public static final Code VIEW_VETERAN_CANDIDATE_PAIRS = new Code("1202"); //View Veteran Candidate Pairs
    public static final Code PROCESS_VETERAN_DUPLICATE_PAIRS = new Code("1203"); //Process Veteran Duplicate Pairs
    public static final Code UNMERGE_VETERAN_MERGED_PAIRS = new Code("1204"); //Unmerge Veteran Merged Pairs
    public static final Code VIEW_S_AND_D_MERGED_PAIRS = new Code("1205"); //View S&D Merged Pairs
    public static final Code VIEW_S_AND_D_CANDIDATE_PAIRS = new Code("1206"); //View S&D Candidate Pairs
    public static final Code PROCESS_S_AND_D_DUPLICATE_PAIRS = new Code("1207"); //Process S&D Duplicate Pairs
    public static final Code EXECUTE_S_AND_D_CANDIDATE_IDENTIFICATION = new Code("1208"); //Execute S&D Candidate Identification
    public static final Code UNMERGE_S_AND_D_MERGED_PAIRS = new Code("1209"); //Unmerge S&D Merged Pairs
    public static final String MERGE_VETERAN = "1201,1202,1203";
    public static final String MERGE_DEPENDENTS = "1205,1206,1207,1208,1209";
    //Add User
    public static final Code ADD_NEW_USER = new Code("1301"); //Add New User
    public static final Code EDIT_USER_ACCOUNT = new Code("1302"); //Edit User Account
    public static final Code DISABLE_USER_ACCOUNT = new Code("1303"); //Disable User Account
    public static final Code VIEW_USER_ACCOUNTS = new Code("1304"); //View User Accounts
    public static final Code ADD_LOCAL_USER = new Code("1305"); //View User Accounts
    public static final Code EDIT_LOCAL_USER = new Code("1306"); //View User Accounts
    public static final String MANAGE_USER_ACCOUNTS = "1301,1302,1303,1304,1305,1306";

    //Handle Undeliverable Mail
    public static final Code PROCESS_UNDELIVERABLE_MAIL = new Code("1401"); //Process Undeliverable Mail

    //Batch Process
    public static final Code EXEC_BATCH_REGISTRY_LOAD = new Code("1501"); //Execute Batch Registry Load

    //Login to System
    public static final Code LOGIN_INTO_SYSTEM = new Code("1601"); //Login To System

    //Address
    public static final Code ADD_ADDRESS = new Code("1701"); //1701 Add Address Information
    public static final Code EDIT_ADDRESS = new Code("1702"); //1702 Edit Address Information
    public static final Code VIEW_ADDRESS = new Code("1703"); //1703 View Address Information (Historical or Current)
    public static final String ADDRESS = "1701,1702,1703";
    public static final String UPDATE_ADDRESS = "1701,1702";

    //Communications
    public static final Code MODIFY_COMMUNICATIONS_STATUS = new Code("1801"); //Modify Communications Status
    public static final Code MANUAL_MAIL_REMAIL_LETTER = new Code("1802"); //Manually Mail/Re-mail Letter
    public static final Code OVERRIDE_CONDITIONS_TO_SEND = new Code("1803"); //Override Conditions To Send
    public static final Code VIEW_COMMUNICATIONS_INFO = new Code("1804"); //View Communications Information
    public static final String COMMUNICATIONS = "1801,1802,1803,1804";

    // CCR10386 -- Handbook
    public static final Code VIEW_HANDBOOK_STATUS = new Code("1805"); //View Handbook Status
    public static final Code VIEW_HANDBOOK = new Code("1806"); //View Handbook

    // 3.6 CCR 10958 added 1807, 1808, 1809, 1810 and 1811
    public static final Code PUBLISH_HANDBOOK = new Code("1807"); //Publish Handbook
    public static final Code MANAGE_HANDBOOK_BATCH = new Code("1808"); //Manage Handbook Batch
    public static final Code MODIFY_HANDBOOK_RELEASE_NUM = new Code("1809"); //Modify Handbook Release Control Number
    public static final String PUBLISH_HANDBOOKS="1807";
    public static final String MANAGE_HANDBOOK_BATCHS="1808";
    // Handbook
    public static final Code VIEW_BENEFITS_AT_A_GLANCE = new Code("1810"); //View Veterans Benefits at a Glance
    public static final Code REPUBLISH_HANDBOOK = new Code("1811"); //Republish handbook

    //ACA
    public static final Code VIEW_ACA_COMMUNICATIONS = new Code("1812");
    public static final Code MANAGE_ACA_COMMUNICATIONS = new Code("1813");


    //EGT
    public static final Code VIEW_EGT_SETTINGS = new Code("1901"); //View EGT Settings
    public static final Code VIEW_FUTUTRE_EGT_SETTINGS = new Code("1902"); //View Future EGT Settings
    public static final Code ADD_EGT_SETTINGS = new Code("1903"); //Add EGT Settings
    public static final Code STOP_EGT_PROCESSING = new Code("1904"); //Stop EGT Processing
    public static final Code EDIT_EGT_SETTINGS = new Code("1905"); //Edit EGT Settings
    public static final Code SCHEDULE_EGT_PROCESSING = new Code("1906"); //Schedule EGT Processing
    public static final String MANAGE_EGT = "1901,1902,1903,1904,1905,1906";

    //Enrollment Eligibility
    public static final Code VIEW_ELIGIBILITY_ENROLLMENT = new Code("2001"); //View Eligibility & Enrollment Information (Historical or Current)
    public static final Code EDIT_ELIGIBILITY = new Code("2002"); //Edit Eligibility Information
    public static final Code EDIT_CANCEL_DECLINE_ENROLLMENT = new Code("2003"); //Edit Cancel/Decline Enrollment Status (can result in deleting enrollment record)
    public static final Code EDIT_ENROLLMENT_OVERRIDE = new Code("2004"); //Edit Enrollment Override
    public static final Code EDIT_ENROLLMENT_APP_DATE = new Code("2005"); //Edit Enrollment Application Date
    public static final String ELIGIBILITY = "2001,2002";
    public static final String ENROLLMENT = "2001,2003,2004,2005";
    //Financials
    public static final Code VIEW_FINANCIAL_INFO = new Code("2101"); //View Financial Information
    public static final Code DELETE_INCOME_TEST = new Code("2102"); //Delete Income Test
    public static final Code ADJUDICATE_INCOME_TEST = new Code("2103"); //Adjudicate Income Test
    public static final Code ADD_INCOME_TEST = new Code("2104"); //Add Income Test
    public static final Code EDIT_INCOME_TEST = new Code("2105"); //Edit Income Test
    public static final String FINANCIALS="2101,2102,2103,2104,2105";

    //Contact
    public static final Code ADD_CONTACT_EXCLUDE_NEXT_OF_KIN = new Code("2201"); //Add Contact (Excluding Next of Kin)
    public static final Code EDIT_CONTACT_EXCLUDE_NEXT_OF_KIN = new Code("2202"); //Edit Contact Information (Excluding Next of Kin)
    public static final Code DELETE_CONTACT_EXCLUDE_NEXT_OF_KIN = new Code("2203"); //Delete Contact (Excluding Next of Kin)
    public static final Code VIEW_CONTACT = new Code("2204"); //View Contact (Historical or Current) (Including Next of Kin)
    public static final String CONTACTS = "2201,2202,2203,2204";
    public static final String UPDATE_ASSOCIATES = "2201,2202,2203";

    //Demographic and Identity Trait info
    public static final Code EDIT_DEMOGRAPHIC_INFO = new Code("2301"); //Edit Demographic Information
    public static final Code EDIT_IDENTITY_TRAIT_INFO = new Code("2302"); //Edit Identity-Trait Information

    public static final Code VIEW_DEMOGRAPHIC_INFO = new Code("2303"); //View Demographic Information
    public static final Code EDIT_SSA_VERIFICATION_STATUS = new Code("2304"); //Edit SSA Verification Status
    public static final Code EDIT_VERIFIED_SSN = new Code("2305"); //Edit Verified SSN
    public static final Code EDIT_PATIENT_SENSITIVITY_FLAG = new Code("2306"); //Edit Patient Sensitivity Flag

    public static final String IDENTITY_TRAITS="2303,2302,2304,2305";
    public static final String PERSONAL ="2301,2303,2306";

    //Insurance
    public static final Code ADD_INSURANCE_INFO = new Code("2401"); //2401 Add Insurance Information
    public static final Code EDIT_INSURANCE_INFO = new Code("2402"); //2402 Edit Insurance Information
    public static final Code VIEW_INSURANCE_INFO = new Code("2403"); //2403 View Insurance Information
    public static final String INSURANCE="2401,2402,2403";
    public static final String UPDATE_INSURANCE = "2401,2402";

    public static final String DEMOGRAPHICS = PERSONAL + "," + IDENTITY_TRAITS + "," + ADDRESS + "," + CONTACTS + "," + INSURANCE;

    //Militray Service
    public static final Code ADD_MILITARY_SERVICE_INFO = new Code("2501"); //2501 Add Military Service Information
    public static final Code EDIT_MILITARY_SERVICE_INFO = new Code("2502"); //2502 Edit Military Service Information
    public static final Code VIEW_MILITARY_SERVICE_INFO = new Code("2503"); //2503 View Military Service Information
    public static final String MILITARY_SERVICE = "2501,2502,2503";
    //POW
    public static final Code VIEW_POW_INFO = new Code("2601"); //View POW Information
    public static final Code EDIT_POW_INFO = new Code("2602"); //Edit POW Information
    public static final Code ADD_POW_INFO = new Code("2603"); //Add POW Information
    public static final Code POW_YES_TO_NO = new Code("2604"); //POW Yes-to-No
    public static final String MANAGE_POW = "2601,2602,2603,2604";

    //UC Manage Person Purple Heart Information
    public static final Code VIEW_PURPLE_HEART_INFO = new Code("2701"); //View Purple Heart Information
    public static final Code EDIT_PURPLE_HEART_INFO = new Code("2702"); //Edit Purple Heart Information
    public static final Code ADD_PURPLE_HEART_INFO = new Code("2703"); //Add Purple Heart Information
    public static final Code LOG_PURPLE_HEART_DOC = new Code("2704"); //Log Purple Heart Documentation

    //Signature
    public static final Code VIEW_SIGNATURE_INFO = new Code("2801"); //View Signature Information
    public static final Code EDIT_SIGNATURE_INFO = new Code("2802"); //Edit Signature Information

    //Registry
    public static final Code VIEW_POW_REGISTRY = new Code("2901"); //View POW Registry
    public static final Code VIEW_PH_REGISTRY = new Code("2902"); //View PH Registry
    public static final Code VIEW_SHAD_REGISTRY = new Code("2903"); //View SHAD Registry
    public static final Code ADD_POW_REGISTRY = new Code("2904"); //Add POW Registry data
    public static final Code ADD_PH_REGISTRY = new Code("2905"); //Add PH Registry data
    public static final Code ADD_SHAD_REGISTRY = new Code("2906"); //Add SHAD Registry data
    public static final Code EDIT_POW_REGISTRY = new Code("2907"); //Edit POW Registry data
    public static final Code EDIT_PH_REGISTRY = new Code("2908"); //Edit PH Registry data
    public static final Code EDIT_SHAD_REGISTRY = new Code("2909"); //Edit SHAD Registry data
    public static final String MANAGE_REGISTRY = "2901,2902,2903,2904,2905,2906,2907,2908,2909";

    //System Parameters
    public static final Code VIEW_SYSTEM_PARAMETERS = new Code("3001"); //View System Parameters
    public static final Code EDIT_PASSWORD_ACTIVE_DAYS = new Code("3002"); //Edit Password Active Days
    public static final Code EDIT_PASSWORD_EXPIRED_DAYS = new Code("3003"); //Edit Password Expired Days
    public static final Code EDIT_FAILED_ATTEMPTS = new Code("3004"); //Edit Failed Attempts

    public static final Code EDIT_RETRANSMIT_EXEC_PERIOD = new Code("3005"); //Edit Retransmit Execution Period
    public static final Code EDIT_RETRANSMIT_DAYS = new Code("3006"); //Edit Retransmit Days
    public static final Code EDIT_MAX_RETRANSMIT_COUNT = new Code("3007"); //Edit Maximum Retransmission Count
    public static final Code EDIT_SSA_SSN_VERIFICATION_FREQUENCY = new Code("3008"); //Edit SSA SSN Verification Frequency
    public static final Code EDIT_DUPLICATE_THRESHOLD_VALUE = new Code("3009"); //Edit Duplicate Threshold Value
    public static final Code EDIT_IVM_DM_IY_CUTOFF_DATE = new Code("3010"); //IVM DM IY Cut Off Date
    public static final Code EDIT_IVM_DM_EXPORTER_MAX_RECORDS = new Code("3011"); //IVM DM Exporter Maximum Records
    public static final String MANAGE_SYSTEM_PARAMETERS ="3001,3002,3003,3004,3005,3006,3007,3008,3009,3010,3011";

    //User Profiles
    public static final Code EDIT_USER_PROFILE_INFO = new Code("3102"); //3102 Edit User Profile Information
    public static final Code VIEW_USER_PROFILE_INFO = new Code("3103"); //3103 View User Profile Information
    public static final String MANAGE_USER_PROFILES= "3102,3103";

    //Capability Sets
    public static final Code ADD_CAPABILITY_SETS = new Code("3201"); //3201 Add Capability Set
    public static final Code EDIT_CAPABILITY_SETS = new Code("3202"); //3202 Edit Capability Set
    public static final Code DELETE_CAPABILITY_SETS = new Code("3203"); //3203 Delete Capability Set
    public static final Code VIEW_CAPABILITY_SETS = new Code("3204"); //3204 View Capability Set
    public static final Code ADD_PERSON_CAPABILITY_SETS = new Code("3910"); //3910 Add Person Capability Set
    public static final Code MANAGE_VOA = new Code("3911"); //3911 VOA Resubmissions
    public static final String MANAGE_CAPABILITY_SETS = "3201,3202,3203,3204";

    //Roles
    public static final Code ADD_ROLES = new Code("3301"); //3301 Add Role
    public static final Code EDIT_ROLES = new Code("3302"); //3302 Edit Role
    public static final Code DELETE_ROLES = new Code("3303"); //3303 Delete Role
    public static final Code VIEW_ROLES = new Code("3304"); //3304 View Role
    public static final String MANAGE_ROLES = "3301,3302,3303,3304";

    public static final String MANAGE_PROFILES_ROLES_SETS = "3101,3102,3103,3104,3201,3202,3203,3204,3301,3302,3303,3304";

    //Search
    public static final Code LIMITED_SEARCH = new Code("3401"); //3401 Search For Person
    public static final Code SEARCH_NAME_ONLY= new Code("3402"); //3402 Search For Person(Name Only)
    public static final Code SEARCH_SSN_ONLY= new Code("3403");
    public static final String SEARCH = "3401,3402,3403";

    //Referece Data (Thresholds)
    public static final Code VIEW_GMT_THRESHOLDS = new Code("3501"); //View GMT Thresholds
    public static final Code VIEW_INCOME_THRESHOLDS = new Code("3502"); //View Income Thresholds
    public static final String VIEW_THRESHOLDS = "3501,3502";
    public static final Code VIEW_PERSON_CLINICAL_DETERMINATION = new Code("3601"); //View Person Clinical Determinations

    //Message log
    public static final Code VIEW_TRANSMISSION_HISTORY = new Code("3701"); //View Transmission History
    public static final Code RE_TRANSMIT_Z11 = new Code("3702"); //Re-transmit Z11
    public static final Code RE_TRANSMIT_Z05 = new Code("3703"); //Re-transmit Z05
    public static final Code RE_TRANSMIT_Z10 = new Code("3704"); //Re-transmit Z10
    public static final Code RE_TRANSMIT_Z04 = new Code("3705"); //Re-transmit Z04
    public static final Code RE_TRANSMIT_Z06 = new Code("3706"); //Re-transmit Z06
    public static final Code VIEW_TRANSMISSION_LOG = new Code("3707"); //View Transmission Log
    public static final Code VIEW_PARSED_MESSAGE = new Code("3708"); //View Parsed Message Data
    public static final Code VIEW_RAW_MESSAGE = new Code("3709"); //View Raw Message Data
    public static final Code SEND_QUERY_MESSAGE_Z07 = new Code("3710"); //Send Query Message (Z07)
    public static final Code VIEW_FEE_BASIS = new Code("3711"); //View Fee Basis Program Information
    public static final String MANAGE_HL7_MESSAGES = "3701,3702,3703,3704,3705,3706,3707,3708,3709";
    public static final String FACILITIES = "3707,3708,3709,3710,3711";
    //Workload
    public static final Code VIEW_WORKLOAD_HISTORY = new Code("3801"); //View Workload History
    public static final Code VIEW_COMMENT_HISTORY = new Code("3802"); //View Comment History
    public static final Code VIEW_STATUS_HISTORY = new Code("3803"); //View Status History
    public static final Code VIEW_ASSIGNMENT_HISTORY = new Code("3804"); //View Assignment History

    public static final Code VIEW_WORKLOAD = new Code("3805"); //View Workload
    public static final Code ASSIGN_WORK_ITEMS_TO_SELF = new Code("3806"); //Assign Workitems to Self
    public static final Code EDIT_WORK_ITEMS = new Code("3807"); //Edit Workitems
    public static final Code CLOSE_WORK_ITEMS = new Code("3808"); //Close Workitems
    public static final Code SEARCH_WORKLIST_ITEMS = new Code("3809"); //Search Worklist Items

    public static final Code TRANSFER_WORK_ITEMS = new Code("3810"); //Transfer Workitems (across groups)
    public static final Code ASSIGN_WORK_ITEMS_TO_OTHERS = new Code("3811"); //Assign Workitems to Others
    public static final String MANAGE_WORKLIST = "3801,3802,3803,3804,3805,3806,3807,3808,3809,3810,3811";

    // Relaxation Percentage
    public static final Code VIEW_RELAXATION_PERCENTAGE = new Code("3901");
    public static final Code EDIT_RELAXATION_PERCENTAGE = new Code("3902");
    public static final String MANAGE_RELAXATION_PERCENTAGE = "3901,3902";

    //Health Benefit Plans
    public static final Code VIEW_HEALTH_BENEFITS_PLANS = new Code("2611");
    public static final Code ASSIGN_HEALTH_BENEFITS_PLANS = new Code("2612");
    public static final Code UNASSIGN_HEALTH_BENEFITS_PLANS = new Code("2613");


    // CCR13211 Heath Benefit Plans Information - Admin Menu
    public static final Code VIEW_HEALTH_BENEFITS_PLAN_INFORMATION = new Code("2616");
    public static final Code EDIT_HEALTH_BENEFITS_PLAN_INFORMATION = new Code("2615");
    public static final Code ADD_HEALTH_BENEFITS_PLAN_INFORMATION = new Code("2614");
    public static final String MANAGE_HBPINFORMATION = "2614,2615,2616";


    //Currently these are define as roles
    //and will be converted to Capabilities later
    public static final Code LOCAL_ADMINISTRATOR = new Code("Local Administrator");
    public static final Code ADMINISTRATOR = new Code("Administrator");
    public static final Code SYSTEM_ADMINISTRATOR = new Code("System Administrator");
    public static final Code EE_MANAGER = new Code("EE Manager");
    public static final Code EE_SUPERVISOR = new Code("EE Supervisor");
    public static final Code EE_LAS = new Code("EE LAS");
    public static final Code DQ_MANAGER = new Code("DQ Supervisor");
    public static final Code DQ_ANALYST = new Code("DQ Analyst");
    public static final Code DQ_SPECIALIST = new Code("DQ Specialist");
    public static final Code DIRECTOR = new Code("Director");
    public static final Code EGT_MANAGER = new Code("EGT Manager");
    public static final Code DQ_UNASSIGNED_POOL = new Code("DQ Unassigned Pool");

    public Capability() {
        super();
    }

    public String getName() {
        return getDescription();
    }

    public static class Code extends AbstractCode {
        private static final long serialVersionUID = -7442343721638482068L;

        private Code(String code) {
            super(code);
        }

        public static Code getByCode(String code) {
            return (Code) getCode(Code.class, code);
        }
    }

    public int compareTo(Object o) {
        if (o != null && o instanceof Capability)
            return getName().compareTo(((Capability)o).getName());
        else
            return 1;
    }
}
