/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents a Cancel Decline Reason.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class CancelDeclineReason extends AbstractNamedActiveLookup {
	
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -3380057954581712851L;

	/* Other Insurance Code */
	public static final Code CODE_OTHER_INSURANCE = new Code("3");

	/* Other Code */
	public static final Code CODE_OTHER = new Code("4");

	/* Dissatisfied with VA Care Code */
	public static final Code CODE_DISSATISFIED_WITH_VA_CARE = new Code("1");

	/* Geographic Access Code */
	public static final Code CODE_GEOGRAPHIC_ACCESS = new Code("2");

	public static class Code extends AbstractCode {
		
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 5839698742745746315L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public CancelDeclineReason() {
		super();
	}
}
