/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents a Cancel Decline Not Processed Reason.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class CancelDeclineNotProcessedReason extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 4553885221854105071L;

	/* Returned To Corresponding Unit Code */
	public static final Code CODE_RETURNED_TO_CORRESPONDING_UNIT = new Code("2");

	/* Waiting For Signature From VAMC Code */
	public static final Code CODE_WAITING_FOR_SIGNATURE_FROM_VAMC = new Code("3");

	/* Unable To Identify Veteran Code */
	public static final Code CODE_UNABLE_TO_IDENTIFY_VETERAN = new Code("4");

	/* Duplicate Code */
	public static final Code CODE_DUPLICATE = new Code("5");

	/* Pending Completion Code */
	public static final Code CODE_PENDING_COMPLETION = new Code("6");

	/* Veteran Rescinded Cancellation Request Code */
	public static final Code CODE_VETERAN_RESCINDED_CANCELLATION_REQUEST = new Code(
			"7");

	/* Other Code */
	public static final Code CODE_OTHER = new Code("8");

	/* Awaiting Signature of Veteran Code */
	public static final Code CODE_AWAITING_SIGNATURE_OF_VETERAN = new Code("9");

	/* Pending Telephone Calls Code */
	public static final Code CODE_PENDING_TELEPHONE_CALLS = new Code("1");

	/* Pending Clarification From Veteran Code */
	public static final Code CODE_PENDING_CLARIFICATION_FROM_VETERAN = new Code(
			"10");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 5264215737313311771L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public CancelDeclineNotProcessedReason() {
		super();
	}
}
