
	/*******************************************************************************
	 * Copyright  2014 VHA. All rights reserved
	 ******************************************************************************/
package gov.va.med.esr.common.model.lookup;


import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;



	/**
	 * This is one of the classes of the Business Object Model (BOM). This class
	 * represents an Camp Lejeune Change Source.
	 * 
	 * @author DNS   zhangs
	 * 
	 */
	public class CampLejeuneChangeSource  extends AbstractNamedActiveLookup {
	
	
		private static final long serialVersionUID = 1213719232377435588L;


		public static final Code CODE_USER = new Code("1");

		public static final Code CODE_CLEAR = new Code("2");
		
		public static final Code CODE_DOD = new Code("3");
		
		public static final Code CODE_VAMC = new Code("4");
		
		public static final Code CODE_HEC = new Code("5");
		
		public static final Code CODE_VOA = new Code("6");
		
		public static final Code CODE_OTHER = new Code("7");

				
		public static class Code extends AbstractCode {
		
			private static final long serialVersionUID = -3165306076632444285L;

			private Code(String code) {
				super(code);
			}

			public static Code getByCode(String code) {
				return (Code) getCode(Code.class, code);
			}
		}

		/**
		 * Default constructor.
		 */
		public CampLejeuneChangeSource() {
			super();
		}
	}
