/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents a Catastrophic Disability Evaluation Method.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class CDDeterminationMethod extends AbstractNamedActiveLookup {
	
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8254279421357226054L;

	/* Physical Examination Code */
	public static final Code CODE_PHYSICAL_EXAMINATION = new Code("3");

	/* Automated Record Review Code */
	public static final Code CODE_AUTOMATED_RECORD_REVIEW = new Code("1");

	/* Medical Record Review Code */
	public static final Code CODE_MEDICAL_RECORD_REVIEW = new Code("2");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -8364273477893520206L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public CDDeterminationMethod() {
		super();
	}
}