/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.model.lookup;

import gov.va.med.esr.common.model.lookup.RaceType.Code;
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;

/**
 * @author DNS   CHENJ2
 * This represents Benefit Applied For
 */
public class BenefitType extends AbstractNamedLookup {
	
	/**
     * 
     */
    private static final long serialVersionUID = -5981510930950724347L;

    /**
     * 
     */
    public static final Code CODE_HEATH_SERVICES = new Code("1");
    public static final Code CODE_DOMICILIARY = new Code("2");
    public static final Code CODE_DENTAL = new Code("4");
    public static final Code CODE_NURSING_HOME = new Code("5");
    public static final Code CODE_ENROLLMENT = new Code("6");
    //Inner class
	public static class Code extends AbstractCode {


        /**
         * 
         */
        private static final long serialVersionUID = 3707868884100483196L;

        private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public BenefitType() {
		super();
	}
}
