/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents a Bad Address Reason.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class BadAddressReason extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 2215006930235279178L;

	/*
	 * Other - Address could not be shared for some reason other than "homeless"
	 * Code
	 */
	public static final Code CODE_OTHER = new Code("OTHER");

	/*
	 * Undeliverable - Mail was returned or is otherwise known to be
	 * undeliverable Code
	 */
	public static final Code CODE_UNDELIVERABLE = new Code("UNDELIVERABLE");

	/* Address Not Found - For use by HEC Only Code */
	public static final Code CODE_ADDRESS_NOT_FOUND = new Code(
			"ADDRESS NOT FOUND");

	/* Veteran has no known address Code */
	public static final Code CODE_HOMELESS = new Code("HOMELESS");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 1949242040290515699L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
      
    public BadAddressReason() {
		super();
	}
}
