/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents an Association Type.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class AssociationType extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -1678691037959197615L;

	/* Emergency Contact Code */
	public static final Code CODE_EMERGENCY_CONTACT = new Code("3");

	/* Other Emergency Contact Code */
	public static final Code CODE_OTHER_EMERGENCY_CONTACT = new Code("4");

	/* Designee Code */
	public static final Code CODE_DESIGNEE = new Code("5");

	/* Power of Attorney Code */
	public static final Code CODE_POWER_OF_ATTORNEY = new Code("7");

	/* Guardian VA Code */
	public static final Code CODE_GUARDIAN_VA = new Code("8");

	/* Guardian Civil Code */
	public static final Code CODE_GUARDIAN_CIVIL = new Code("9");

	/* Spouse Code */
	public static final Code CODE_SPOUSE = new Code("10");

	/* Dependent Code */
	public static final Code CODE_DEPENDENT = new Code("11");

	/* Primary Next of Kin Code */
	public static final Code CODE_PRIMARY_NEXT_OF_KIN = new Code("1");

	/* Other Next of Kin Code */
	public static final Code CODE_OTHER_NEXT_OF_KIN = new Code("2");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -6852121223703591884L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public AssociationType()
    {
		super();
	}
}
