/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents an Asset Type.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class AssetType extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 719383050055897726L;

	/* Other Code */
	public static final Code CODE_OTHER = new Code("O");

	/* Real Estate Code */
	public static final Code CODE_REAL_ESTATE = new Code("R");

	/* Stocks and Bonds Code */
	public static final Code CODE_STOCKS_AND_BONDS = new Code("S");

	/* Cash Code */
	public static final Code CODE_CASH = new Code("C");

	/* Non-Liquid Asset Code */
	public static final Code CODE_NON_LIQUID_ASSET = new Code("NLA");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 2935106266336942365L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public AssetType() {
		super();
	}
}