/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents an Agent Orange Exposure Location.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class AgentOrangeExposureLocation extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -2963861350351749003L;

	/* Korean DMZ Location Type Code */
	public static final Code CODE_KOREAN_DMZ = new Code("K");

	/* Vietnam Location Type Code */
	public static final Code CODE_VIETNAM = new Code("V");
    
    /* Other Location Type Code */
    public static final Code CODE_OTHER = new Code("O");    

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -3391288511400002591L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public AgentOrangeExposureLocation() {
		super();
	}
}