package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// Java Classes

// Library Classes

// Framework Classes

/**
 * @author Commons Team
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.class table="EXTREMITY" mutable="false"
 * @hibernate.cache usage="read-only"
 */
public class AffectedExtremity extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -5331500828784102164L;

	/* Right Upper Code */
	public static final Code CODE_RIGHT_UPPER = new Code("1");

	/* Right Lower Code */
	public static final Code CODE_RIGHT_LOWER = new Code("2");

	/* Left Upper Code */
	public static final Code CODE_LEFT_UPPER = new Code("3");

	/* Left Lower Code */
	public static final Code CODE_LEFT_LOWER = new Code("4");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 1249994473192352197L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public AffectedExtremity() {
		super();
	}
}