/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents an Agent Orange Exposure Location.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class AddressType extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -2611846245936281449L;

	/* Business Address Code */
	public static final Code CODE_BUSINESS_ADDRESS = new Code("B");
	
	/* Conficential Address Code */
	public static final Code CODE_CONFIDENTIAL_ADDRESS = new Code("CNF");
	
	/* Permanent Address */
	public static final Code CODE_RESIDENTIAL_ADDRESS = new Code("P");
	
	/* Permanent Address Code. ESR uses permanent, permanent mailing and corresondence address 
	 * type interchangeably
	 */
	public static final Code CODE_PERMANENT_ADDRESS = new Code("M");

	/* Home Address Code */
	public static final Code CODE_PRIMARY_RESIDENCE = new Code("H");
	
	/* Temporary Correspondence Address Code */
	public static final Code CODE_TEMPORARY_CORRESPONDENCE_ADDRESS = new Code("C");

    /* Birth Address Code */
    public static final Code CODE_BIRTH_ADDRESS = new Code("N");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -7818058621286671153L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public AddressType() {
		super();
	}
}
