/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents an Address Change Source.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class AddressChangeSource extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -6038264093467296031L;

	/* HEC - Health Eligibility Center Code */
	public static final Code CODE_HEC = new Code("HEC");

	/* NCOA - National Change of Address Code */
	public static final Code CODE_NCOA = new Code("NCOA");

	/* USPS - Change of Address file from US Postal Service Code */
	public static final Code CODE_USPS = new Code("USPS");

	/* VAINS - Philadelphia Insurance Center Code */
	public static final Code CODE_VAINS = new Code("VAINS");

	/* VAMC - Veterans Affairs Medical Center Code */
	public static final Code CODE_VAMC = new Code("VAMC");

	/* BVA - Board of Veterans Appeals Code */
	public static final Code CODE_BVA = new Code("BVA");

	/* HBSC - Health Benefits Service Center Code */
	public static final Code CODE_HBSC = new Code("HBSC");

	/* VA - US Dept of Veterans Affairs Code */
	public static final Code CODE_VA = new Code("VA");
	
	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -5076104555142708112L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public AddressChangeSource() {
		super();
	}
}
