/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

/**
 * Initial javadoc for class AckType. TODO - Add content here
 * 
 * Created Oct 6, 2005 9:40:14 AM
 * 
 * @author DNS   BOHMEG
 */
public class AckType extends AbstractNamedActiveLookup {
	
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 347729880478395952L;

	public static final Code CODE_AA = new Code("AA");

	public static final Code CODE_AE = new Code("AE");

	public static final Code CODE_AR = new Code("AR");

	public static class Code extends AbstractCode {
		
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 379787004445318271L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			AckType.class.getPackage(); // force loading of requisite constants in case funny class loader behavior
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public AckType() {
		super();
	}
    
    public String getCodeDescription() {
        return this.getCode() + " : " + this.getDescription();
    }
}
