package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

public class AACIndicator extends AbstractNamedActiveLookup {
	
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 3009693842156906912L;

	/* VBA Query Initiated */
	public static final Code CODE_NEW_RECORD = new Code("1");

	/* VBA Queried - Pending Response */
	public static final Code CODE_AAC_QUERIED_PENDING = new Code("2");

	/* No VBA Data on File */
	public static final Code CODE_AAC_QUERIED_NO_DATA = new Code("3");

	/* VBA Data Auto-uploaded */
	public static final Code CODE_DATA_RECEIVED = new Code("4");

	/* VBA Data Pending Review */
	public static final Code CODE_DATA_PENDING_REVIEW = new Code("5");

	/* VBA Data Manually Accepted */
	public static final Code CODE_DATA_ACCEPTED = new Code("6");

	/* VBA Data Rejected */
	public static final Code CODE_DATA_REJECTED = new Code("7");

	/* VBA Data Inclusive */
	public static final Code CODE_DATA_INCONCLUSIVE = new Code("8");

	public static class Code extends AbstractCode {
		
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 3437429384839150138L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public AACIndicator() {
		super();
	}
}