/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Apr 17, 2006
 *
 */
package gov.va.med.esr.common.model.ivmdm;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.esr.common.model.lookup.MessageStatus;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author Yi He
 * @version 1.0
 */
//CCR12713, archive previous completed migrations for same IY upon record completion
public class IVMMigrationArchive extends AbstractKeyedEntity {

    private static final long serialVersionUID = -5179160614446954198L;

    private PersonEntityKey personEntityKey;
    private BigDecimal ivmMigrateId;
    private Serializable personId;
    private Date migrationDate;
    private Integer incomeYear;
    private String icn;
    private String loadFailureReason; // Reason IVM failed to load migration data from ESR
    private boolean stampped; // Stampped by the IVM Date/Time process
    private boolean remigrate;
    private MessageStatus status = null;

	public IVMMigrationArchive() {
		super();
	}

	public IVMMigrationArchive(IVMMigration m) {
		super();
		this.setIvmMigrateId(new BigDecimal(m.getEntityKey().getKeyValueAsString()));
		this.setPersonEntityKey(m.getPersonEntityKey());
		this.setMigrationDate(m.getMigrationDate());
		this.setIncomeYear(m.getIncomeYear());
		this.setIcn(m.getIcn());
		this.setLoadFailureReason(m.getLoadFailureReason());
		this.setStampped(m.isStampped());
		this.setRemigrate(m.isRemigrate());
		this.setStatus(m.getStatus());
	}

	public IVMMigrationArchive(EntityKey identifier) {
		super(identifier);
	}

	public IVMMigrationArchive(EntityKey identifier, Date createdOn, Date modifiedOn,
			Integer version) {
		super(identifier, createdOn, modifiedOn, version);
	}

    public PersonIdEntityKey getPersonEntityKey() {
        return personId != null ? CommonEntityKeyFactory.createPersonIdEntityKey(personId) : null;
    }

    public void setPersonEntityKey(PersonEntityKey key) {
        personId = key != null ? key.getKeyValue() : null;
    }

    public Date getMigrationDate() {
    	return this.migrationDate;
    }

    public void setMigrationDate(Date date) {
    	this.migrationDate = date;
    }

    public Integer getIncomeYear() {
    	return this.incomeYear;
    }

    public void setIncomeYear(Integer incomeYear) {
    	this.incomeYear = incomeYear;
    }

    public String getIcn() {
    	return this.icn;
    }

    public void setIcn(String icn) {
    	this.icn = icn;
    }

    public String getLoadFailureReason() {
    	return this.loadFailureReason;
    }

    public void setLoadFailureReason(String reason) {
    	this.loadFailureReason = reason;
    }

    public boolean isRemigrate() {
    	return this.remigrate;
    }

    public void setRemigrate(boolean remigrate) {
    	this.remigrate = remigrate;
    }

    public boolean isStampped() {
    	return this.stampped;
    }

    public void setStampped(boolean stampped) {
    	this.stampped = stampped;
    }

    /* Hibernate persisted field */
    private Serializable getPersonId() {
    	return this.personId;
    }

    private void setPersonId(Serializable personId) {
    	this.personId = personId;
    }

    public MessageStatus getStatus() {
    	return status;
    }

    public void setStatus(MessageStatus status) {
    	this.status = status;
    }

    public BigDecimal getIvmMigrateId() {
    	return ivmMigrateId;
    }

    public void setIvmMigrateId(BigDecimal ivmMigrateId) {
    	this.ivmMigrateId = ivmMigrateId;
    }
}

