/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Apr 18, 2006
 *
 */
package gov.va.med.esr.common.model.ivmdm;

// Java classes
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.lang.Validate;

// Library classes

// Framework classes
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;

// EDB Classes
import gov.va.med.esr.common.model.lookup.IVMDMType;

/**
 * @author Yi He
 * @version 1.0
 */
public class IVMDMExtractBatch extends AbstractKeyedEntity {

	private static final long serialVersionUID = -6697665245788864658L;
    
    public IVMDMExtractBatch() {
		super();
	}

	public IVMDMType getMigrationType() {
		return this.migrationType;
	}
	
	public void setMigrationType(IVMDMType type) {
		this.migrationType = type;
	}
	
	public String getExtractFileName() {
		return this.extractFileName;
	}
	
	public void setExtractFileName(String name) {
		this.extractFileName = name;
	}

	public Date getExtractStartDate() {
		return this.extractStartDate;
	}
	
	public void setExtractStartDate(Date start) {
		this.extractStartDate = start;
	}
	
	public Date getExtractEndDate() {
		return this.extractEndDate;
	}
	
	public void setExtractEndDate(Date end) {
		this.extractEndDate = end;
	}
	
	public Integer getExtractRecordCount() {
		return this.extractRecordCount;
	}
	
    public void setExtractRecordCount(Integer count) {
    	this.extractRecordCount = count;
    }
	/**
	 * @return A collection of ExtractRecord object
	 */
	public Set getExtractRecords() {
		return Collections.unmodifiableSet(getInternalExtractRecords());
	}

	public IVMDMExtractRecord getExtractRecordByEntityKey(EntityKey identifier) {
		return (IVMDMExtractRecord) AbstractKeyedEntity.getEntityByEntityKey(getExtractRecords(), identifier);
	}

	public IVMDMExtractRecord removeExtractRecordByEntityKey(EntityKey identifier) {
		return (IVMDMExtractRecord) AbstractKeyedEntity.removeEntityByEntityKey(getInternalExtractRecords(), identifier);
	}



	/**
	 * Getter - for hibernate use only.
	 * 
	 * @return
	 */
	private Set getInternalExtractRecords() {
		if (this.internalExtractRecords == null) {
			this.internalExtractRecords = new HashSet();
		}
		return this.internalExtractRecords;
	}

	/**
	 * Setter - for hibernate use only.
	 * 
	 * @param 
	 */
	private void setInternalExtractRecords(Set extractRecords) {
		this.internalExtractRecords = extractRecords;
	}

	/**
	 * Add a ReportExtractRecord for this report setup. This method takes care of Bidirectional
	 * setting of ReportExtractRecord's report setup.
	 * 
	 * @param extractRecord
	 */
	public void addExtractRecord(IVMDMExtractRecord extractRecord) {
		Validate.notNull(extractRecord, "Null extractRecord specified.");
		extractRecord.setExtractBatch(this);
		getInternalExtractRecords().add(extractRecord);
	}

	/**
	 * Add a collection of ExtractRecords to this report setup. This method takes care of
	 * Bidirectional setting of ReportExtractRecord's report setup.
	 * 
	 * @param extractRecords
	 */
	public void addAllExtractRecords(Set extractRecords) {
		Validate.notNull(extractRecords, "Null set of extractRecords specified.");
		Iterator iter = extractRecords.iterator();
		while(iter.hasNext()) {
		    ((IVMDMExtractRecord)iter.next()).setExtractBatch(this);
		}
		Set internal = this.getInternalExtractRecords();
		internal.addAll(extractRecords);
	}

	/**
	 * Remove an ReportExtractRecord for this batch
	 * 
	 * @param extractRecord
	 */
	public void removeExtractRecord(IVMDMExtractRecord extractRecord) {
		Validate.notNull(extractRecord, "Null extractRecord specified.");
		getInternalExtractRecords().remove(extractRecord);
		extractRecord.setExtractBatch(null);
	}

	public void removeAllExtractRecords() {
		this.getInternalExtractRecords().clear();
	}
	
	private IVMDMType migrationType;
    private String extractFileName;
    private Date extractStartDate;
    private Date extractEndDate;
    private Integer extractRecordCount;
    private Set internalExtractRecords;
}

