package gov.va.med.esr.common.model.ivmdm;

import gov.va.med.fw.model.AbstractKeyedEntity;

public class IVMClearLoadErrorStatistics extends AbstractKeyedEntity {
    private static final long serialVersionUID = 820266166246554212L;
    
    private int     recordsProcessedCount        = 0;
    private int     errorReasonsClearedCount     = 0;
    private int     noErrorReasonsExistsCount    = 0;
    private int     noLongerMeetingCriteriaCount = 0;

    public void incrementErrorReasonsClearedCount() {
        errorReasonsClearedCount++;
        recordsProcessedCount++;
    }

    public void incrementNoErrorReasonsExistsCount() {
        noErrorReasonsExistsCount++;
        recordsProcessedCount++;
    }

    public void incrementNoLongerMeetingCriteriaCount() {
        noLongerMeetingCriteriaCount++;
        recordsProcessedCount++;
    }

    /**
     * @param errorReasonsClearedCount
     *            The errorReasonsClearedCount to set.
     */
    private void setErrorReasonsClearedCount(Integer errorReasonsClearedCount) {
        this.errorReasonsClearedCount = toIntValue(errorReasonsClearedCount);
    }

    /**
     * @param noErrorReasonsExistsCount
     *            The noErrorReasonsExistsCount to set.
     */
    private void setNoErrorReasonsExistsCount(Integer noErrorReasonsExistsCount) {
        this.noErrorReasonsExistsCount = toIntValue(noErrorReasonsExistsCount);
    }

    /**
     * @param noLongerMeetingCriteriaCount
     *            The noLongerMeetingCriteriaCount to set.
     */
    private void setNoLongerMeetingCriteriaCount(Integer noLongerMeetingCriteriaCount) {
        this.noLongerMeetingCriteriaCount = toIntValue(noLongerMeetingCriteriaCount);
    }

    /**
     * @param recordsProcessedCount
     *            The recordsProcessedCount to set.
     */
    private void setRecordsProcessedCount(Integer recordsProcessedCount) {
        this.recordsProcessedCount = toIntValue(recordsProcessedCount);
    }

    /**
     * @return Returns the errorReasonsClearedCount.
     */
    public Integer getErrorReasonsClearedCount() {
        return new Integer(errorReasonsClearedCount);
    }

    /**
     * @return Returns the noErrorReasonsExistsCount.
     */
    public Integer getNoErrorReasonsExistsCount() {
        return new Integer(noErrorReasonsExistsCount);
    }

    /**
     * @return Returns the noLongerMeetingCriteriaCount.
     */
    public Integer getNoLongerMeetingCriteriaCount() {
        return new Integer(noLongerMeetingCriteriaCount);
    }

    /**
     * @return Returns the recordsProcessedCount.
     */
    public Integer getRecordsProcessedCount() {
        return new Integer(recordsProcessedCount);
    }

    private int toIntValue(Integer value) {
        return value == null ? 0 : value.intValue();
    }
}