/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.insurance;

// Library classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Import Framework classes
import gov.va.med.esr.common.infra.ImpreciseDate;

/**
 * @author DNS   MANSOG
 * @author Yi He
 * @version 1.0
 */
public class PrivateInsurance extends InsurancePolicy {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -16425087603397877L;

	/**
	 * Subscriber ID (Policy Number) is defined as the insured's unique
	 * identification number assigned by the payer organization for this policy.
	 * If this insurance is an individual policy the policy # shall be stored in
	 * this field.
	 */
	private String policyNumber = null;

	/**
	 * Effective Date is defined as the date this policy went into effect for
	 * this patient.
	 */
	private ImpreciseDate policyEffectiveDate = null;

	/**
	 * Expiration date is defined as the date this insurance policy coverage
	 * expires for this patient.
	 */
	private ImpreciseDate policyExpirationDate = null;

	/**
	 * Creates a new PrivateInsurance object.
	 */
	public PrivateInsurance() {
		super();
	}

	public String getPolicyNumber() {
		return this.policyNumber;
	}

	public void setPolicyNumber(String policyNumber) {
		this.policyNumber = policyNumber;
	}

	public ImpreciseDate getPolicyEffectiveDate() {
		return this.policyEffectiveDate;
	}

	public void setPolicyEffectiveDate(ImpreciseDate policyEffectiveDate) {
		this.policyEffectiveDate = policyEffectiveDate;
	}

	public ImpreciseDate getPolicyExpirationDate() {
		return this.policyExpirationDate;
	}

	public void setPolicyExpirationDate(ImpreciseDate policyExpirationDate) {
		this.policyExpirationDate = policyExpirationDate;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("policyNumber", this.policyNumber);
		builder.append("policyEffectiveDate", this.policyEffectiveDate);
		builder.append("policyExpirationDate", this.policyExpirationDate);
	}
}