/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.insurance;

// Java classes
import gov.va.med.esr.common.infra.ImpreciseDate;

import java.util.Date;

// Library classes
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author DNS   MANSOG
 * @author Yi He
 * @version 1.0
 */
public class Medicare extends InsurancePolicy {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 4364075784216689620L;

	/**
	 * Enrolled in Medicare Part A Indicator is defined as a code to indicate if
	 * this patient is enrolled in Medicare Hospital Insurance Part A
	 */
	private Boolean enrolledInPartA = null;

	/**
	 * Enrolled in Medicare Part B Indicator is defined as a code to indicateif
	 * this patient is enrolled in Medicare Hospital Insurance Part B
	 */
	private Boolean enrolledInPartB = null;

	/**
	 * Enrolled in Medicare Part A and B Indicator is defined as a code to indicate if
	 * this patient is enrolled in both Medicare Hospital Insurance Part A and B
	 */
	private Boolean enrolledInPartAB = null;
	
	/**
	 * Part A Effective Date is defined as the date Medicare Part A went into
	 * effect for this patient.
	 */
	// private Date partAEffectiveDate = null;

	/**
	 * Part B Effective Date is defined as the date Medicare Part B went into
	 * effect for this patient.
	 */
	// private Date partBEffectiveDate = null;

	
	 // CCR9568 - imprecise date
	 private ImpreciseDate partAEffectiveDate = null;
	 private ImpreciseDate partBEffectiveDate = null;
	 private ImpreciseDate partABEffectiveDate = null;
	 
	private String medicareClaimNumber = null;

	private String nameOnMedicareCard = null;

	/**
	 * Creates a new Medicare object.
	 */
	public Medicare() {
		super();
	}

	// ----------------------------------------------------------------------------
	// Public method(s)
	// ----------------------------------------------------------------------------

	public Boolean isEnrolledInPartA() {
		return this.enrolledInPartA;
	}

	public Boolean getEnrolledInPartA() {
		return this.enrolledInPartA;
	}

	public void setEnrolledInPartA(Boolean enrolledInPartA) {
		this.enrolledInPartA = enrolledInPartA;
	}

	public Boolean isEnrolledInPartB() {
		return this.enrolledInPartB;
	}

	public Boolean getEnrolledInPartB() {
		return this.enrolledInPartB;
	}

	public void setEnrolledInPartB(Boolean enrolledInPartB) {
		this.enrolledInPartB = enrolledInPartB;
	}

	public Boolean isEnrolledInPartAB() {
		return this.enrolledInPartAB;
	}

	public Boolean getEnrolledInPartAB() {
		return this.enrolledInPartAB;
	}

	public void setEnrolledInPartAB(Boolean enrolledInPartAB) {
		this.enrolledInPartAB = enrolledInPartAB;
	}
	/*
	public Date getPartAEffectiveDate() {
		return this.partAEffectiveDate;
	}

	public void setPartAEffectiveDate(Date partAEffectiveDate) {
		this.partAEffectiveDate = partAEffectiveDate;
	}

	public Date getPartBEffectiveDate() {
		return this.partBEffectiveDate;
	}

	public void setPartBEffectiveDate(Date partBEffectiveDate) {
		this.partBEffectiveDate = partBEffectiveDate;
	}
	*/

	public String getMedicareClaimNumber() {
		return this.medicareClaimNumber;
	}

	public void setMedicareClaimNumber(String medicareNumber) {
		this.medicareClaimNumber = medicareNumber;
	}

	public String getNameOnMedicareCard() {
		return nameOnMedicareCard;
	}

	public void setNameOnMedicareCard(String nameOnMedicareCard) {
		this.nameOnMedicareCard = nameOnMedicareCard;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("enrolledInPartA", this.enrolledInPartA);
		builder.append("enrolledInPartB", this.enrolledInPartB);		
		builder.append("enrolledInPartAB", this.enrolledInPartAB);
		builder.append("partAEffectiveDate", this.partAEffectiveDate);
		builder.append("partBEffectiveDate", this.partBEffectiveDate);
		builder.append("partABEffectiveDate", this.partABEffectiveDate);
		builder.append("medicareClaimNumber", this.medicareClaimNumber);
	}
	

    public boolean equals(Object obj) {
        if (obj == null)
            return false;
        if (obj == this)
            return true;
        if (obj.getClass() != getClass())
            return false;

        Medicare rhs = (Medicare) obj;
        return new EqualsBuilder().
            appendSuper(super.equals(obj)).
            append(getIdentifier(), rhs.getIdentifier()).
            append(enrolledInPartA, rhs.enrolledInPartA).
            append(enrolledInPartB, rhs.enrolledInPartB).
            append(medicareClaimNumber, rhs.medicareClaimNumber).
            append(nameOnMedicareCard, rhs.nameOnMedicareCard).
            append(partAEffectiveDate, rhs.partAEffectiveDate).
            append(partBEffectiveDate, rhs.partBEffectiveDate).
            isEquals();
    }

	/**
	 * @see com.VHA.fw.model.AbstractEntity#hashCode()
	 */
	public int hashCode() {
			return new HashCodeBuilder(17,37).
			append(this.getIdentifier()).
			append(this.enrolledInPartA).
			append(this.enrolledInPartB).
			append(this.medicareClaimNumber).
			append(this.nameOnMedicareCard).
			append(this.partAEffectiveDate).
			append(this.partBEffectiveDate).toHashCode();
	}

	public void setPartAEffectiveDate(ImpreciseDate partAEffectiveDate) {
		this.partAEffectiveDate = partAEffectiveDate;
	}

	public void setPartBEffectiveDate(ImpreciseDate partBEffectiveDate) {
		this.partBEffectiveDate = partBEffectiveDate;
	}

	public void setPartABEffectiveDate(ImpreciseDate partABEffectiveDate) {
		this.partABEffectiveDate = partABEffectiveDate;
	}
	
	public ImpreciseDate getPartAEffectiveDate() {
		return partAEffectiveDate;
	}

	public ImpreciseDate getPartBEffectiveDate() {
		return partBEffectiveDate;
	}
	
	public ImpreciseDate getPartABEffectiveDate() {
		return partABEffectiveDate;
	}

}